IF EXISTS (SELECT * FROM SYS.procedures WHERE NAME = 'P_MEDIAF_CALCULAR_LANCAMENTOS')
BEGIN
	DROP PROCEDURE P_MEDIAF_CALCULAR_LANCAMENTOS
END
GO 
/****** Object:  StoredProcedure [dbo].[P_MEDIAF_CALCULAR_LANCAMENTOS]    Script Date: 03/09/2014 11:21:39 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO
--EXECUTE P_MEDIAF_CALCULAR_LANCAMENTOS 1,1,0
CREATE PROCEDURE [dbo].[P_MEDIAF_CALCULAR_LANCAMENTOS] @CD_EMP INT = 1, @CD_USU INT = 1, @CONSULTA INT=0 AS
	SET NOCOUNT ON
	
	DECLARE @CD_FILIAL INT
	DECLARE MediaPFiliais CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT CD_FILIAL 
	FROM 
		PRC_FILIAL 
	WHERE 
		CD_EMP=1
		AND STS_FILIAL=0
	ORDER BY 
		CD_FILIAL
	
	OPEN MediaPFiliais
	
	FETCH NEXT FROM MediaPFiliais INTO @CD_FILIAL
	WHILE @@FETCH_STATUS=0
	  BEGIN
		PRINT	'FILIAL ' + CONVERT(VARCHAR(5), @CD_FILIAL) + 
				' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
		
		EXECUTE P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL @CD_EMP,@CD_FILIAL,1,0		
		
		FETCH NEXT FROM MediaPFiliais INTO @CD_FILIAL
	  END
	  
	PRINT 'CONCLUiDO.'
	CLOSE MediaPFiliais
	DEALLOCATE MediaPFiliais